/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.RegionAnchors;
import de.z0rdak.yawp.core.region.AbstractRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5321;

public abstract class AbstractMarkableRegion
extends AbstractRegion
implements IMarkableRegion {
    protected int priority;
    protected IMarkableArea area;
    protected AreaType areaType;
    protected RegionAnchors tpAnchors;

    public AbstractMarkableRegion(String name, IMarkableArea area, class_1657 owner, class_5321<class_1937> dimension, AbstractRegion parent) {
        super(name, dimension, RegionType.LOCAL, owner);
        this.area = area;
        this.areaType = area.getAreaType();
        this.priority = Services.REGION_CONFIG.getDefaultPriority();
        if (parent != null) {
            this.setParent(parent);
        }
        this.tpAnchors = new RegionAnchors();
    }

    public AbstractMarkableRegion(String name, IMarkableArea area, class_1657 owner, class_5321<class_1937> dimension) {
        this(name, area, owner, dimension, null);
    }

    public AbstractMarkableRegion(String name, IMarkableArea area, class_2338 tpTarget, class_1657 owner, class_5321<class_1937> dimension) {
        this(name, area, owner, dimension, null);
    }

    public AbstractMarkableRegion(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    @Override
    protected boolean setParent(IProtectedRegion parent) {
        if (this.parent == null) {
            boolean isParentLocalOrDim = parent.getRegionType() == RegionType.DIMENSION || parent.getRegionType() == RegionType.LOCAL;
            return isParentLocalOrDim && super.setParent(parent);
        }
        if (this.parent.getRegionType() == RegionType.LOCAL && parent.getRegionType() == RegionType.DIMENSION) {
            return super.setParent(parent);
        }
        if (this.parent.getRegionType() == RegionType.DIMENSION && parent.getRegionType() == RegionType.LOCAL) {
            return super.setParent(parent);
        }
        return false;
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        if (child.getRegionType() == RegionType.LOCAL && child.getParent() == null) {
            return super.addChild(child);
        }
        if (child.getRegionType() == RegionType.LOCAL && child.getParent().getRegionType() == RegionType.DIMENSION) {
            return super.addChild(child);
        }
        return false;
    }

    @Override
    public boolean contains(class_2338 position) {
        return this.area.contains(position);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10566("tp_anchors", (class_2520)this.tpAnchors.serializeNBT());
        nbt.method_10569("priority", this.priority);
        nbt.method_10582("area_type", this.areaType.areaType);
        nbt.method_10566("area", this.area.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        try {
            this.tpAnchors = new RegionAnchors(nbt.method_10562("tp_anchors"));
        }
        catch (Exception e) {
            this.tpAnchors = new RegionAnchors();
        }
        this.priority = nbt.method_10550("priority");
        AreaType areaType = AreaType.of(nbt.method_10558("area_type"));
        if (areaType == null) {
            Constants.LOGGER.error("Error loading region data for: '{}' in dim '{}'", (Object)this.getName(), (Object)this.dimension.method_29177());
            throw new IllegalArgumentException("Error loading region data for: '" + this.getName() + "' in dim '" + String.valueOf(this.dimension.method_29177()) + "'");
        }
        this.areaType = areaType;
    }

    @Override
    public IMarkableArea getArea() {
        return this.area;
    }

    @Override
    public void setArea(IMarkableArea area) {
        this.area = area;
        this.areaType = area.getAreaType();
    }

    @Override
    public void rename(String newName) {
        this.setName(newName);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    @Override
    public RegionAnchors getTpAnchors() {
        return this.tpAnchors;
    }
}

